/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

public abstract class ArrayHelper {
    public static boolean equals(byte[] lhs, byte[] rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs.length != rhs.length) {
            return false;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (lhs[i] == rhs[i]) continue;
            return false;
        }
        return true;
    }

    public static int hash(byte[] array) {
        int hash = 0;
        for (int i = 0; i < array.length; ++i) {
            hash = 31 * hash + array[i];
        }
        return hash;
    }

    public static String toString(byte[] array) {
        int length = array.length;
        if (length == 0) {
            return "{}";
        }
        String result = String.valueOf(new StringBuffer("{").append(length).append(" bytes: "));
        if (length > 100) {
            length = 100;
        }
        for (int i = 0; i < length; ++i) {
            char c = (char)array[i];
            if (' ' <= c && c <= '~') {
                result = String.valueOf(result).concat(String.valueOf(String.valueOf(new StringBuffer("[").append(c).append("]"))));
                continue;
            }
            short s = array[i];
            if (s < 0) {
                s = (short)(s + 256);
            }
            result = String.valueOf(result).concat(String.valueOf(String.valueOf(new StringBuffer("(").append(s).append(")"))));
        }
        if (length < array.length) {
            result = String.valueOf(result).concat("...");
        }
        return String.valueOf(result).concat("}");
    }
}

